// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

float rand(vec2 co){
	float temp; 
	return fract(sin(dot(co.xy ,(vec2)(12.9898f,78.233f))) * 43758.5453f,&temp);
}
float myMod(float x ,float y)
{
	return x-y * floor (x/y);
}
__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float speed = 1.0f;
	float angle = 2.0f;
	float power = 2.0f;
	
	vec2 q = p;
	float t = pow(progress, power)*speed;
	p = p -0.5f;
	for (int i = 0; i < 7; i++) {
		p = (vec2)(sin(t)*p.x + cos(t)*p.y, sin(t)*p.y - cos(t)*p.x);
		t += angle;
		p.x = _abs( myMod(p.x, 2.0f)-1.0f);
		p.y = _abs( myMod(p.y, 2.0f)-1.0f);
	}
	vec4 gl_FragColor = mix(
		mix(INPUT(input1, param, q), INPUT(input2, param,q), progress),
		mix(INPUT(input1, param, p), INPUT(input2, param,p), progress), 1.0f - 2.0f*_abs(progress - 0.5f));

	write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}